﻿//////////////////////////////////////////////
// ContentLoader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Exportable ;
	class Node ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

#include "ContentLoadResult.h"

// nkExport
#include <NilkinsExport/Exporter/ExporterLoadResult.h>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT ContentLoader final
	{
		public :

			// Ces fonctions sont dupliquées depuis nkGraphics
			// Il faudrait voir si ça ne serait pas un bon plan de les factoriser dans nkExport (TODO)
			// Fonctions pratiques
			static nkExport::ExporterLoadResult inputData (nkMemory::StringView filePath) ;
			static nkMemory::String inputDataStr (nkMemory::StringView filePath) ;
			static nkExport::ExporterLoadResult inputDataSources (nkMemory::StringView sources) ;
			static bool outputData (nkMemory::StringView content, nkMemory::StringView path) ;

			// Save
			static bool saveTreeDeclaration (nkExport::Node* tree, nkMemory::StringView pathFromData) ;
			static bool saveObjectDeclaration (nkExport::Exportable* object, nkMemory::StringView pathFromData) ;

			// Scripts
			static ContentLoadResultScript loadScriptDeclaration (nkMemory::StringView pathFromData, bool loadResource = true) ;
			static ContentLoadResultScript processScriptSources (nkMemory::StringView sources, bool loadResource = true) ;
			static ContentLoadResultScript processScriptTree (nkExport::Node* tree, bool loadResource = true) ;
	} ;
}